
##############################
# Country definition for ENG #
##############################

province =
{ id            = 5
  radar_station = { size = 1 current_size = 1 }
  anti_air      = 4
  air_base      = { size = 4 current_size = 4 }
  naval_base    = { size = 10 current_size = 10 }
}                 # Scapa Flow
province =
{ id            = 9
  ic            = 4
  radar_station = { size = 1 current_size = 1 }
  anti_air      = 2
  air_base      = { size = 4 current_size = 4 }
}                 # Glasgow
province =
{ id            = 10
  ic            = 3
  radar_station = { size = 1 current_size = 1 }
}                 # Edinburgh
province =
{ id            = 11
  ic            = 3
  radar_station = { size = 1 current_size = 1 }
  anti_air      = 1
  air_base      = { size = 4 current_size = 4 }
  naval_base    = { size = 2 current_size = 2 }
}                 # Sunderland
province = { id = 12 ic = 2 } # Blackpool
province =
{ id            = 13
  ic            = 5
  radar_station = { size = 2 current_size = 2 }
  anti_air      = 2
  air_base      = { size = 10 current_size = 10 }
  naval_base    = { size = 10 current_size = 10 }
}                 # Sheffield
province =
{ id         = 14
  ic         = 6
  anti_air   = 4
  air_base   = { size = 10 current_size = 10 }
  naval_base = { size = 10 current_size = 10 }
}              # Liverpool
province =
{ id            = 15
  radar_station = { size = 1 current_size = 1 }
}                 # Cardiff
province = { id = 16 ic = 6 anti_air = 2 } # Birmingham
province =
{ id            = 17
  radar_station = { size = 3 current_size = 3 }
  anti_air      = 4
  air_base      = { size = 10 current_size = 10 }
  naval_base    = { size = 10 current_size = 10 }
}                 # Norwich
province =
{ id            = 19
  ic            = 6
  radar_station = { size = 1 current_size = 1 }
  anti_air      = 3
}                 # London
province =
{ id            = 20
  landfort      = 0
  coastalfort   = 3
  radar_station = { size = 4 current_size = 4 }
  anti_air      = 5
  air_base      = { size = 10 current_size = 10 }
  naval_base    = { size = 10 current_size = 10 }
}                 # Dover
province =
{ id            = 21
  radar_station = { size = 4 current_size = 4 }
  anti_air      = 6
  air_base      = { size = 10 current_size = 10 }
  naval_base    = { size = 10 current_size = 10 }
}                 # Portsmouth
province =
{ id            = 22
  radar_station = { size = 1 current_size = 1 }
}                 # Bristol
province =
{ id            = 23
  radar_station = { size = 3 current_size = 3 }
  anti_air      = 6
  air_base      = { size = 10 current_size = 10 }
  naval_base    = { size = 10 current_size = 10 }
}                 # Plymouth
province = { id = 28 oilpool = 1000 supplypool = 2000 } # Belfast
province =
{ id          = 31

  coastalfort = 1
  anti_air    = 2
  air_base    = { size = 4 current_size = 4 }
  naval_base  = { size = 5 current_size = 5 }
  oilpool     = 100
  supplypool  = 500
}               # Malta
province =
{ id          = 348
  landfort    = 6

  anti_air    = 6
  air_base    = { size = 4 current_size = 4 }
  naval_base  = { size = 10 current_size = 10 }
  oilpool     = 200
  supplypool  = 500
}               # Gibraltar
province =
{ id       = 444
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Cyprus
province =
{ id         = 538
  anti_air   = 1
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 4 current_size = 4 }
  oilpool    = 100
  supplypool = 500
}              # Bermuda
province =
{ id         = 576
  anti_air   = 2
  air_base   = { size = 6 current_size = 6 }
  naval_base = { size = 10 current_size = 10 }
}              # Newfoundland
province =
{ id       = 652
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Andros
province =
{ id         = 866
  anti_air   = 2
  air_base   = { size = 2 current_size = 2 }
  naval_base = { size = 5 current_size = 5 }
  oilpool    = 100
  supplypool = 200
}              # Falkland Islands
province =
{ id       = 873
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Georgetown
province = { id = 900 anti_air = 2 } # Suez
province = { id = 901 anti_air = 2 } # Port Said
province = { id = 903 anti_air = 2 } # Cairo
province =
{ id         = 906
  anti_air   = 5
  air_base   = { size = 7 current_size = 7 }
  naval_base = { size = 10 current_size = 10 }
}              # Alexandria
province =
{ id         = 988
  anti_air   = 1
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 2 current_size = 2 }
  oilpool    = 1000
  supplypool = 2000
}              # Freetown
province =
{ id       = 1002
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Accra
province =
{ id       = 1008
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Lagos
province =
{ id       = 1061
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Mombasa
province =
{ id       = 1066
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Khartoum
province =
{ id       = 1296
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Mandalay
province =
{ id         = 1299
  anti_air   = 3
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 10 current_size = 10 }
}              # Rangoon
province =
{ id          = 1315
  coastalfort = 1
  anti_air    = 4
  air_base    = { size = 4 current_size = 4 }
  naval_base  = { size = 10 current_size = 10 }
  oilpool     = 100
  supplypool  = 500
}               # Hong Kong
province =
{ id          = 1353

  coastalfort = 3
  anti_air    = 6
  air_base    = { size = 8 current_size = 8 }
  naval_base  = { size = 10 current_size = 10 }
  oilpool     = 1000
  supplypool  = 5000
}               # Singapore
province =
{ id         = 1457
  anti_air   = 3
  naval_base = { size = 2 current_size = 2 }
  air_base   = { size = 4 current_size = 4 }
}              # Calcutta
province = { id = 1459 oilpool = 100 supplypool = 500 } # Ranchi
province = { id = 1465 ic = 2 } # Rajkot
province =
{ id       = 1467
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Indore
province =
{ id       = 1469
  ic       = 9
  anti_air = 2
  air_base = { size = 4 current_size = 4 }
}            # Delhi
province = { id = 1478 ic = 2 } # Bikaner
province = { id = 1479 ic = 3 } # Jodhpur
province =
{ id         = 1494
  anti_air   = 1
  air_base   = { size = 8 current_size = 8 }
  naval_base = { size = 8 current_size = 8 }
}              # Karachi
province =
{ id         = 1505
  ic         = 2
  anti_air   = 3
  air_base   = { size = 10 current_size = 10 }
  naval_base = { size = 10 current_size = 10 }
}              # Bombay
province = { id = 1513 ic = 2 } # Mangalore
province =
{ id       = 1514
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Cochin
province =
{ id         = 1516
  anti_air   = 1
  air_base   = { size = 2 current_size = 2 }
  naval_base = { size = 2 current_size = 2 }
}              # Trincomalee
province =
{ id          = 1517
  coastalfort = 3
  anti_air    = 2
  air_base    = { size = 10 current_size = 10 }
  naval_base  = { size = 10 current_size = 10 }
  oilpool     = 1000
  supplypool  = 2000
}               # Colombo
province =
{ id       = 1644
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Kuching
province = { id = 1797 anti_air = 1 } # Jerusalem
province =
{ id         = 1798
  anti_air   = 1
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 2 current_size = 2 }
}              # Tel Aviv
province =
{ id         = 1813
  anti_air   = 1
  naval_base = { size = 2 current_size = 2 }
}              # Aden
province =
{ id         = 1817
  anti_air   = 2
  air_base   = { size = 6 current_size = 6 }
  naval_base = { size = 10 current_size = 10 }
  oilpool    = 100
  supplypool = 200
}              # Diego Garcia Island

#####################
# Country main data #
#####################

country =
{ tag                    = ENG
  capital                = 19
  manpower               = 485
  # Resource Reserves
  energy                 = 1000
  metal                  = 1000
  rare_materials         = 500
  oil                    = 500
  supplies               = 500
  money                  = 100
  # #######################
  # ##CONVOYS##############
  # #######################
  transports             = 1200
  escorts                = 150
  policy =
  { date              = { year = 0 month = january day = 0 }
    democratic        = 10
    political_left    = 2
    freedom           = 10
    free_market       = 8
    professional_army = 7
    defense_lobby     = 5
    interventionism   = 6
  }
  SpyInfo                = { country = "ENG" NumberOfSpies = 10 }
  #SpyInfo                = { country = "GER" NumberOfSpies = 4 }
  #SpyInfo                = { country = "FRA" NumberOfSpies = 4 }
  #SpyInfo                = { country = "SOV" NumberOfSpies = 8 }
  #SpyInfo                = { country = "SPA" NumberOfSpies = 4 }
  #SpyInfo                = { country = "POL" NumberOfSpies = 8 }
  #SpyInfo                = { country = "SWE" NumberOfSpies = 5 }
  #SpyInfo                = { country = "NOR" NumberOfSpies = 4 }
  #SpyInfo                = { country = "FIN" NumberOfSpies = 5 }
  #SpyInfo                = { country = "YUG" NumberOfSpies = 8 }
  #SpyInfo                = { country = "HUN" NumberOfSpies = 5 }
  #SpyInfo                = { country = "BUL" NumberOfSpies = 5 }
  #SpyInfo                = { country = "BEL" NumberOfSpies = 8 }
  #SpyInfo                = { country = "DEN" NumberOfSpies = 4 }
  #SpyInfo                = { country = "HOL" NumberOfSpies = 8 }
  #SpyInfo                = { country = "USA" NumberOfSpies = 4 }
  #SpyInfo                = { country = "ALB" NumberOfSpies = 4 }
  #SpyInfo                = { country = "GRE" NumberOfSpies = 4 }
  #SpyInfo                = { country = "ARG" NumberOfSpies = 4 }
  #SpyInfo                = { country = "BRA" NumberOfSpies = 4 }
  #SpyInfo                = { country = "JAP" NumberOfSpies = 4 }
  #SpyInfo                = { country = "ROM" NumberOfSpies = 5 }
  #SpyInfo                = { country = "LIT" NumberOfSpies = 5 }
  #SpyInfo                = { country = "LUX" NumberOfSpies = 4 }
  #SpyInfo                = { country = "POR" NumberOfSpies = 4 }
  #SpyInfo                = { country = "ITA" NumberOfSpies = 5 }
  #SpyInfo                = { country = "CHI" NumberOfSpies = 4 }
  #SpyInfo                = { country = "MEX" NumberOfSpies = 4 }
  #SpyInfo                = { country = "AST" NumberOfSpies = 5 }
  #SpyInfo                = { country = "NZL" NumberOfSpies = 5 }
  #SpyInfo                = { country = "CAN" NumberOfSpies = 5 }
  #SpyInfo                = { country = "IRE" NumberOfSpies = 4 }
  #SpyInfo                = { country = "IRQ" NumberOfSpies = 8 }
  #SpyInfo                = { country = "BHU" NumberOfSpies = 4 }
  #SpyInfo                = { country = "YEM" NumberOfSpies = 4 }
  #SpyInfo                = { country = "ETH" NumberOfSpies = 4 }
  # GREAT BRITAIN
  nationalprovinces      = { 3    5    6    7    8    9    10   11   12   13   14   15   16   17   19   20   21   22   23   28   29   348  31   1494
                             1481 1480 1465 1466 1479 1482 1483 1475 1476 1478 1477 1877 1878 1469 1470 1471 1472 1456 1468 1467 1464 1463 1474 1460
                             1459 1457 1458 1461 1508 1462 1505 1506 1507 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 1284 1285 1286 1287
                             1288 1289 1290 1291 1898 1304 1295 1296 1301 1302 1346 1299 1298 1297 1300 1292 1454 444 
                           }
  # GREAT BRITAIN
  ownedprovinces         = { 3    5    6    7    8    9    10   11   12   13   14   15   16   17   19   20   21   22   23   575  576  28   29   348 
                             31   444  1494 1481 1480 1465 1466 1479 1482 1483 1475 1476 1478 1477 1877 1878 1469 1470 1471 1472 1456 1468 1467 1464
                             1463 1474 1460 1459 1457 1458 1461 1508 1462 1505 1506 1507 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 1284
                             1285 1286 1287 1288 1289 1290 1291 1898 1304 1295 1296 1301 1302 1346 1299 1298 1297 1300 1292 1454 1799 1797 1796 404 
                             1802 1803 406  407  1813 1814 1504 1820 1798 1349 1350 1351 1352 1353 1644 1646 1647 1315 758  891  871  873  806 
                             807  808  809  897  538  652  653  664  665  666  668  805  896  866  1147 1148 1816 1817 1136 1815 1132 1139 1062 1140
                             1141 1064 1060 1061 1059 1035 1036 1112 1111 1105 1124 1125 1104 1099 1129 1126 1128 1000 1001 1002 1008 1007 999  1009
                             1010 1011 1145 1085 1012 988  982  1622 1683 1684 1685 1686 1763 1761 1767 1768 1769 1770 1757 1759 1760 1752 1753 1754
                             1755 1758 900  901  902  903  904  905  906  907  908  909  910  911  912  913  914  915  4    1020 1019 1021 1022 1027
                             1023 1026 1024 1025 1800 1801 1065 1066 1069 1068 1067 1029 1028 1032 1031 1030 1040 1041 1614 1611 1822
                           }
  # GREAT BRITAIN
  controlledprovinces    = { 3    5    6    7    8    9    10   11   12   13   14   15   16   17   19   20   21   22   23   575  576  28   29   348 
                             31   444  1494 1481 1480 1465 1466 1479 1482 1483 1475 1476 1478 1477 1877 1878 1469 1470 1471 1472 1456 1468 1467 1464
                             1463 1474 1460 1459 1457 1458 1461 1508 1462 1505 1506 1507 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 1284
                             1285 1286 1287 1288 1289 1290 1291 1898 1304 1295 1296 1301 1302 1346 1299 1298 1297 1300 1292 1454 1799 1797 1796 404 
                             1802 1803 406  407  1813 1814 1504 1820 1798 1349 1350 1351 1352 1353 1644 1646 1647 1315 758  891  871  873  806 
                             807  808  809  897  538  652  653  664  665  666  668  805  896  866  1147 1148 1816 1817 1136 1815 1139 1062 1140 1141
                             1064 1060 1061 1059 1132 1035 1036 1112 1111 1105 1124 1125 1104 1099 1129 1126 1128 1000 1001 1002 1008 1007 999  1009
                             1010 1011 1145 1085 1012 988  982  1622 1683 1684 1685 1686 1763 1761 1767 1768 1769 1770 1757 1759 1760 1752 1753 1754
                             1755 1758 900  901  902  903  904  905  906  907  908  909  910  911  912  913  914  915  4    1020 1019 1021 1022 1027
                             1023 1026 1024 1025 1800 1801 1065 1066 1069 1068 1067 1029 1028 1032 1031 1030 1040 1041 1614 1611 1822
                           }
  # Commonwealth Tech '36
  # early escort carrier
  # UK 1939 techs
  # ######################
  techapps               = { 12100 2520  4190  4140  4010  4020  4030  4050  4120  4130  4220  2150  2160  2010  2020  2040  2050  2030  2070  2290 
                             2300  2310  2320  2330  2400  2450  2460  2510  1010  1020  1030  1190  1200  1210  1220  1230  1110  1150  1310  1340 
                             5010  5020  5030  5050  5060  5070  5080  5090  5100  5110  5190  5200  5210  5310  5320  5350  5360  5410  5420  5470 
                             5480  5490  9010  9020  9030  9140  9150  9160  9040  9060  9090  6010  6030  6110  6120  8010  8020  8030  8040  8050 
                             8070  8100  8120  8130  8310  3010  3020  3030  3070  3080  3090  3100  3130  3140  3150  3190  3200  3210  3250  3260 
                             3270  3280  3320  3330  3340  3350  3400  3410  3420  14000 14010 4040  12110
                           }
  diplomacy =
  { relation = { tag = AFG value = -75 }
    relation = { tag = ARG value = 75 }
    relation = { tag = AST value = 200 } # was access = yes
    relation = { tag = BEL value = 150 }
    relation = { tag = BHU value = 200 access = yes }
    relation = { tag = BUL value = 20 }
    relation = { tag = CAN value = 200 } # was access = yes
    relation = { tag = CHI value = 100 }
    relation = { tag = SLO value = -200 }
    relation = { tag = JAP value = -50 }
    relation =
    { tag        = DEN
      value      = 100
      guaranteed = { day = 19 month = april year = 1939 }
    }
    relation = { tag = EST value = 65 }
    relation = { tag = FIN value = 85 }
    relation = { tag = FRA value = 150 }
    relation = { tag = GER value = -200 }
    relation =
    { tag        = GRE
      value      = 50
      guaranteed = { day = 13 month = april year = 1939 }
    }
    relation = { tag = GUA value = 50 }
    relation =
    { tag        = HOL
      value      = 125
      guaranteed = { day = 19 month = april year = 1939 }
    }
    relation = { tag = HON value = 50 }
    relation = { tag = HUN value = -50 }
    relation = { tag = IRE value = 50 }
    relation = { tag = IRQ value = 100 access = yes }
    relation = { tag = ITA value = -100 }
    relation = { tag = LAT value = 65 }
    relation = { tag = LIT value = 65 }
    relation = { tag = MEX value = 50 }
    relation = { tag = NEP value = 200 access = yes }
    relation = { tag = NOR value = 90 }
    relation = { tag = NZL value = 200 } # was access = yes
    relation = { tag = OMN value = 150 access = yes }
    relation = { tag = PER value = 25 }
    relation =
    { tag        = POL
      value      = 200
      guaranteed = { day = 30 month = march year = 1939 }
    }
    relation =
    { tag        = POR
      value      = 100
      guaranteed = { day = 22 month = may year = 1939 }
    }
    relation =
    { tag        = ROM
      value      = 50
      guaranteed = { day = 13 month = april year = 1939 }
    }
    relation = { tag = SAF value = 200 } # was access = yes
    relation =
    { tag        = SAU
      value      = 100
      guaranteed = { day = 11 month = february year = 1934 }
    }
    relation =
    { tag        = SCH
      value      = 50
      guaranteed = { day = 19 month = april year = 1939 }
    }
    relation = { tag = SIA value = 70 }
    relation = { tag = SOV value = -25 }
    relation = { tag = SPA value = -65 }
    relation = { tag = SWE value = 80 }
    relation =
    { tag        = TUR
      value      = 75
      guaranteed = { day = 17 month = may year = 1938 }
    }
    relation = { tag = USA value = 150 }
    relation = { tag = VEN value = -10 }
    relation =
    { tag        = YEM
      value      = 150
      access     = yes
      guaranteed = { day = 11 month = february year = 1934 }
    }
  }
  headofstate            = { type = 9 id = 1033 }
  headofgovernment       = { type = 9 id = 1037 }
  foreignminister        = { type = 9 id = 1003 }
  armamentminister       = { type = 9 id = 1061 }
  ministerofsecurity     = { type = 9 id = 1005 }
  ministerofintelligence = { type = 9 id = 1102 }
  chiefofstaff           = { type = 9 id = 1119 }
  chiefofarmy            = { type = 9 id = 1129 }
  chiefofnavy            = { type = 9 id = 1137 }
  chiefofair             = { type = 9 id = 1149 }
  dormant_ministers      = { 1001 1031 1002 1004 1081 1006 1007 1008 1127 1128 1009 1010 1082 }
  # ###################
  # UK OOB 1939########
  # ###################
  landunit =
  { location = 22
    id       = { type = 13016 id = 1 }
    name     = "Ф˾ "
    division =
    { experience = 20
      id         = { type = 13016 id = 2 }
      name       = "1ʦ "
      type       = infantry
      strength   = 80
      model      = 2
    }
    division =
    { experience = 20
      id         = { type = 13016 id = 3 }
      name       = "2ʦ "
      type       = infantry
      strength   = 80
      model      = 2
    }
  }
  landunit =
  { location = 17
    id       = { type = 13016 id = 4 }
    name     = "˾ "
    division =
    { experience = 20
      id         = { type = 13016 id = 5 }
      name       = "4ʦ "
      type       = infantry
      strength   = 75
      model      = 2
    }
    division =
    { experience = 20
      id         = { type = 13016 id = 6 }
      name       = "12''ʦ "
      type       = infantry
      strength   = 50
    }
    division =
    { experience = 20
      id         = { type = 13016 id = 7 }
      name       = "18ʦ "
      type       = infantry
      strength   = 60
    }
    division =
    { experience = 15
      id         = { type = 13016 id = 8 }
      name       = "44''ʦ "
      type       = infantry
      strength   = 50
      model      = 1
    }
    division =
    { experience = 20
      id         = { type = 13016 id = 9 }
      name       = "54'³'ʦ "
      type       = infantry
      strength   = 50
      model      = 1
    }
  }
  landunit =
  { location = 19
    id       = { type = 13016 id = 10 }
    name     = "׶ս "
    division =
    { experience = 35
      id         = { type = 13016 id = 1111 }
      name       = "ʼ½ܲ "
      type       = hq
      strength   = 100
      model      = 1
    }
    division =
    { experience = 35
      id         = { type = 13016 id = 11 }
      name       = "47'׶'ʦ "
      type       = infantry
      strength   = 60
      model      = 0
    }
    division =
    { experience = 35
      id         = { type = 13016 id = 12 }
      name       = "56'׶'ʦ "
      type       = infantry
      strength   = 50
      model      = 1
    }
  }
  landunit =
  { location = 11
    id       = { type = 13016 id = 13 }
    name     = "˾ "
    division =
    { experience = 20
      id         = { type = 13016 id = 14 }
      name       = "5ʦ "
      type       = infantry
      strength   = 70
      model      = 2
    }
    division =
    { experience = 15
      id         = { type = 13016 id = 15 }
      name       = "49''ʦ"
      type       = infantry
      strength   = 50
      model      = 1
    }
    division =
    { experience = 15
      id         = { type = 13016 id = 16 }
      name       = "46'׵'ʦ "
      type       = infantry
      strength   = 50
      model      = 1
    }
    division =
    { experience = 20
      id         = { type = 13016 id = 17 }
      name       = "23'ŵɭ'ʦ "
      type       = infantry
      strength   = 50
      model      = 1
    }
    division =
    { experience = 20
      id         = { type = 13016 id = 18 }
      name       = "50'ŵɭ'ʦ "
      type       = infantry
      strength   = 50
      model      = 1
    }
  }
  landunit =
  { location = 8
    id       = { type = 13016 id = 19 }
    name     = "ո˾ "
    division =
    { experience = 35
      id         = { type = 13016 id = 20 }
      name       = "9'ո'ʦ "
      type       = infantry
      strength   = 50
      model      = 2
    }
    division =
    { experience = 45
      id         = { type = 13016 id = 21 }
      name       = "51'ߵ'ʦ "
      type       = infantry
      strength   = 70
      model      = 2
    }
  }
  landunit =
  { location = 21
    id       = { type = 13016 id = 22 }
    name     = "ϲ˾ "
    division =
    { experience = 35
      id         = { type = 13016 id = 1112 }
      name       = "ӢԶ˾ "
      type       = hq
      strength   = 100
      model      = 1
    }
    division =
    { experience = 20
      id         = { type = 13016 id = 23 }
      name       = "3ʦ "
      type       = infantry
      strength   = 75
      model      = 2
    }
    division =
    { experience = 15
      id         = { type = 13016 id = 24 }
      name       = "1'ʼ'װʦ "
      type       = light_armor
      strength   = 80
      model      = 0
    }
    division =
    { experience = 15
      id         = { type = 13016 id = 25 }
      name       = "48'׵'ʦ "
      type       = motorized
      strength   = 60
      model      = 0
    }
    division =
    { experience = 10
      id         = { type = 13016 id = 26 }
      name       = "78ʦ "
      type       = infantry
      strength   = 50
      model      = 1
    }
    division =
    { experience = 15
      id         = { type = 13016 id = 27 }
      name       = "43'˹'ʦ "
      type       = infantry
      strength   = 50
      model      = 1
    }
    division =
    { experience = 15
      id         = { type = 13016 id = 28 }
      name       = "45ʦ "
      type       = infantry
      strength   = 50
      model      = 1
    }
  }
  landunit =
  { location = 15
    id       = { type = 13016 id = 29 }
    name     = "˾ "
    division =
    { experience = 15
      id         = { type = 13016 id = 30 }
      name       = "55''ʦ "
      type       = motorized
      strength   = 50
    }
    division =
    { experience = 15
      id         = { type = 13016 id = 31 }
      name       = "42''ʦ "
      type       = infantry
      strength   = 50
      model      = 1
    }
    division =
    { experience = 15
      id         = { type = 13016 id = 32 }
      name       = "66ʦ "
      type       = infantry
      strength   = 50
    }
    division =
    { experience = 15
      id         = { type = 13016 id = 33 }
      name       = "38'ʿ'ʦ "
      type       = infantry
      strength   = 50
    }
    division =
    { experience = 15
      id         = { type = 13016 id = 34 }
      name       = "53'ʿ'ʦ "
      type       = infantry
      strength   = 50
      model      = 1
    }
  }
  landunit =
  { location = 1315
    id       = { type = 13016 id = 35 }
    name     = "˾ "
    division =
    { experience = 35
      id         = { type = 13016 id = 36 }
      name       = "۷ "
      type       = garrison
      strength   = 100
      locked     = yes
    }
  }
  landunit =
  { location = 1353
    id       = { type = 13016 id = 37 }
    name     = "¼˾ "
    division =
    { experience = 35
      id         = { type = 13016 id = 38 }
      name       = "¼· "
      type       = garrison
      strength   = 100
      locked     = yes
    }
  }
  landunit =
  { location = 348
    id       = { type = 13016 id = 39 }
    name     = "ֱ˾ "
    division =
    { experience = 45
      id         = { type = 13016 id = 40 }
      name       = "ֱӷ "
      type       = garrison
      strength   = 100
      locked     = yes
    }
  }
  landunit =
  { location = 31
    id       = { type = 13016 id = 41 }
    name     = "˾ "
    division =
    { experience = 35
      id         = { type = 13016 id = 42 }
      name       = " "
      type       = garrison
      strength   = 100
      locked     = yes
    }
  }
  landunit =
  { location = 1517
    id       = { type = 13016 id = 43 }
    name     = "˾ "
    division =
    { experience = 35
      id         = { type = 13016 id = 44 }
      name       = " "
      type       = garrison
      strength   = 100
      locked     = yes
    }
  }
  landunit =
  { location = 1866 # Bagdad
    id       = { type = 13016 id = 45 }
    name     = "ж˾ "
    division =
    { experience    = 15
      id            = { type = 13016 id = 46 }
      name          = "7Ħлʦ "
      type          = motorized
      extra         = anti_air
      brigade_model = 1
      strength      = 100
    }
    division =
    { experience    = 35
      id            = { type = 13016 id = 47 }
      name          = "8Ħлʦ "
      type          = motorized
      extra         = artillery
      brigade_model = 3
      strength      = 100
    }
    division =
    { experience = 35
      id         = { type = 13016 id = 48 }
      name       = "2װʦ "
      type       = light_armor
      strength   = 100
      extra      = engineer
      model      = 0
    }
  }
  # #############################
  # #UK Forces in India##########
  # #############################
  landunit =
  { location = 1285
    id       = { type = 13016 id = 300 }
    name     = "1ӡʦ "
    division =
    { experience = 5
      id         = { type = 13016 id = 301 }
      name       = "1ӡʦ "
      type       = infantry
      strength   = 100
      model      = 1
    }
  }
  landunit =
  { location = 1471
    id       = { type = 13016 id = 302 }
    name     = "2ӡʦ "
    division =
    { experience = 5
      id         = { type = 13016 id = 303 }
      name       = "2ӡʦ "
      type       = infantry
      strength   = 100
      model      = 1
    }
  }
  landunit =
  { location = 1512
    id       = { type = 13016 id = 304 }
    name     = "3ӡʦ "
    division =
    { experience = 5
      id         = { type = 13016 id = 305 }
      name       = "3ӡʦ "
      type       = infantry
      strength   = 100
      model      = 1
    }
  }
  landunit =
  { location = 1514
    id       = { type = 13016 id = 306 }
    name     = "4ӡʦ "
    division =
    { experience = 5
      id         = { type = 13016 id = 307 }
      name       = "4ӡʦ "
      type       = infantry
      strength   = 100
      model      = 2
    }
  }
  landunit =
  { location = 1507
    id       = { type = 13016 id = 308 }
    name     = "5ӡʦ "
    division =
    { experience = 5
      id         = { type = 13016 id = 309 }
      name       = "5ӡʦ "
      type       = infantry
      strength   = 100
      model      = 2
    }
  }
  # landunit = { location = 1461 id = { type = 13016 id = 310 } name = "6ӡʦ " division = { experience =  5 id = { type = 13016 id #= 311 } 	name = "6ӡʦ " type = infantry strength  = 100 }
  # }
  # landunit = {
  # location = 1457
  # id = { type = 13016 id = 312 }
  # name = "7ӡʦ "
  # division = { experience = 35
  # id = { type = 13016 id = 313 }
  # name = "7ӡʦ "
  # type = infantry
  # strength  = 100
  # }
  # }
  # landunit = {
  # location = 1464
  # id = { type = 13016 id = 423 }
  # name = "10ӡʦ "
  # division = { experience = 35
  # id = { type = 13016 id = 424 }
  # name = "10ӡʦ "
  # type = infantry
  # strength  = 100
  # }
  # }
  # landunit = {
  # location = 1494
  # id = { type = 13016 id = 425 }
  # name = "8ӡʦ "
  # division = { experience = 35
  # id = { type = 13016 id = 426 }
  # name = "8ӡʦ "
  # type = infantry
  # strength  = 100
  # }
  # }
  # landunit = {
  # location = 1475
  # id = { type = 13016 id = 427 }
  # name = "9ӡʦ "
  # division = { experience = 35
  # id = { type = 13016 id = 428 }
  # name = "9ӡʦ "
  # type = infantry
  # strength  = 100
  # }
  # }
  # ####################################
  # #UK Colonial Forces in East Africa##
  # ####################################
  landunit =
  { name     = "1յֳ "
    location = 1066
    id       = { type = 13016 id = 400 }
    division =
    { experience = 0
      id         = { type = 13016 id = 401 }
      name       = "1յֳ "
      type       = militia
      strength   = 100
    }
  }
  landunit =
  { name     = "2յֳ "
    location = 1029
    id       = { type = 13016 id = 402 }
    division =
    { experience = 0
      id         = { type = 13016 id = 403 }
      name       = "2յֳ "
      type       = militia
      strength   = 100
    }
  }
  landunit =
  { name     = "3յֳ "
    location = 1032
    id       = { type = 13016 id = 404 }
    division =
    { experience = 0
      id         = { type = 13016 id = 405 }
      name       = "3յֳ "
      type       = militia
      strength   = 100
    }
  }
  landunit =
  { name     = "1ڸɴֳ "
    location = 1060
    id       = { type = 13016 id = 406 }
    division =
    { experience = 0
      id         = { type = 13016 id = 407 }
      name       = "1ڸɴֳ "
      type       = militia
      strength   = 100
    }
  }
  landunit =
  { name     = "2ڸɴֳ "
    location = 1061
    id       = { type = 13016 id = 408 }
    division =
    { experience = 0
      id         = { type = 13016 id = 409 }
      name       = "2ڸɴֳ "
      type       = militia
      strength   = 100
    }
  }
  landunit =
  { name     = "1ֳ "
    location = 1062
    id       = { type = 13016 id = 410 }
    division =
    { experience = 0
      id         = { type = 13016 id = 411 }
      name       = "1ֳ "
      type       = militia
      strength   = 100
    }
  }
  landunit =
  { name     = "2ֳ "
    location = 1140
    id       = { type = 13016 id = 412 }
    division =
    { experience = 0
      id         = { type = 13016 id = 413 }
      name       = "2ֳ "
      type       = militia
      strength   = 100
    }
  }
  landunit =
  { name     = "1̹ɣֳ "
    location = 1139
    id       = { type = 13016 id = 414 }
    division =
    { experience = 0
      id         = { type = 13016 id = 415 }
      name       = "1̹ɣֳ "
      type       = militia
      strength   = 100
    }
  }
  landunit =
  { name     = "2̹ɣֳ "
    location = 1062
    id       = { type = 13016 id = 416 }
    division =
    { experience = 0
      id         = { type = 13016 id = 417 }
      name       = "2̹ɣֳ "
      type       = militia
      strength   = 100
    }
  }
  landunit =
  { name     = " "
    location = 1299
    id       = { type = 13016 id = 418 }
    division =
    { experience = 15
      id         = { type = 13016 id = 419 }
      name       = "1鲽ǹ "
      type       = infantry
      strength   = 100
    }
    division =
    { experience = 15
      id         = { type = 13016 id = 420 }
      name       = "2鲽ǹ "
      type       = infantry
      strength   = 100
    }
  }
  landunit =
  { name     = "˹̹˾ "
    location = 1797 # Jerusalem
    id       = { type = 13016 id = 421 }
    division =
    { experience = 5
      id         = { type = 13016 id = 422 }
      name       = "˹̹ʦ "
      type       = infantry
      strength   = 100
      model      = 1
    }
  }
  # #######################
  # #####UK Naval OOB######
  # #####1 Sept. 1939######
  # #######################
  # Home Fleet#
  navalunit =
  { name     = " "
    id       = { type = 13016 id = 500 }
    location = 5 # Scapa Flow
    base     = 5
    division =
    { id    = { type = 13016 id = 501 }
      name  = "ɶѷ "
      type  = battleship
      model = 2
    }
    division =
    { id    = { type = 13016 id = 502 }
      name  = "޵ "
      type  = battleship
      model = 2
    }
    division =
    { id    = { type = 13016 id = 503 }
      name  = "ʼ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 13016 id = 504 }
      name  = "Ȩ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 13016 id = 505 }
      name  = "˹ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 13016 id = 506 }
      name  = "º "
      type  = battlecruiser
      model = 2
    }
    division =
    { id    = { type = 13016 id = 507 }
      name  = " "
      type  = battlecruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 508 }
      name  = " "
      type  = battlecruiser
      model = 1
    }
    division =
    { id            = { type = 13016 id = 509 }
      name          = "ʼҷۺ "
      type          = carrier
      model         = 2
      extra         = cag
      brigade_model = 3
    }
    division =
    { id            = { type = 13016 id = 510 }
      name          = "ŭ "
      type          = carrier
      model         = 1
      extra         = cag
      brigade_model = 3
    }
    division =
    { id    = { type = 13016 id = 511 }
      name  = "Ů "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 13016 id = 512 }
      name  = "лƶº "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 13016 id = 515 }
      name  = "ķ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 516 }
      name  = " "
      type  = light_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 517 }
      name  = "ҵ "
      type  = light_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 524 }
      name  = " "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 525 }
      name  = "Ӷ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 519 }
      name  = "ӵķ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 520 }
      name  = " "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 526 }
      name  = "ŵ˺ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 527 }
      name  = "Ŧ˹ "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 13016 id = 513 }
      name  = " "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 13016 id = 514 }
      name  = "˹غ "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 13016 id = 521 }
      name  = "Ҷī˹ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 522 }
      name  = " "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 518 }
      name  = "ᶡ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 523 }
      name  = "Ǻ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 568 }
      name  = "1֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 566 }
      name  = "2֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 561 }
      name  = "3֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 562 }
      name  = "4֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 564 }
      name  = "5֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 528 }
      name  = "6֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 529 }
      name  = "7֧ "
      type  = destroyer
      model = 2
    }
    division =
    { id    = { type = 13016 id = 530 }
      name  = "8֧ "
      type  = destroyer
      model = 2
    }
    division =
    { id    = { type = 13016 id = 576 }
      name  = "9֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 575 }
      name  = "10֧ "
      type  = destroyer
      model = 1
    }
  }
  navalunit =
  { name     = "Ԥ "
    id       = { type = 13016 id = 560 }
    location = 5 # Scapa Flow
    base     = 5
    division =
    { id    = { type = 13016 id = 563 }
      name  = "ɯŮ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 13016 id = 565 }
      name  = "¸Һ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 13016 id = 567 }
      name  = "ޱЪ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 569 }
      name  = "˹ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 574 }
      name  = "׶غ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 577 }
      name  = "˹ "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 13016 id = 600 }
      name  = "º "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 13016 id = 635 }
      name  = " "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 640 }
      name  = "ƺ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 641 }
      name  = "˺ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 642 }
      name  = "ֺ "
      type  = light_cruiser
      model = 0
    }
  }
  # 2nd Submarine Squadron#
  navalunit =
  { name     = "ڶǱͧ "
    id       = { type = 13016 id = 531 }
    location = 5
    base     = 5
    division =
    { id    = { type = 13016 id = 532 }
      name  = "5Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 13016 id = 533 }
      name  = "6Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 13016 id = 534 }
      name  = "7Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
  }
  # 5th Submarine Squadron#
  navalunit =
  { name     = "Ǳͧ "
    id       = { type = 13016 id = 535 }
    location = 5
    base     = 5
    division =
    { id    = { type = 13016 id = 536 }
      name  = "12Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
  }
  # 1st Transport Squadron#
  navalunit =
  { name     = "һ佢 "
    id       = { type = 13016 id = 537 }
    location = 5 # Scapa Flow
    base     = 5
    division =
    { id    = { type = 13016 id = 538 }
      name  = "1佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 539 }
      name  = "2佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 5660 }
      name  = "3佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 5661 }
      name  = "4佢֧ "
      type  = transport
      model = 0
    }
  }
  # Channel Force#
  navalunit =
  { name     = "Ͽ "
    id       = { type = 13016 id = 540 }
    location = 21 # Southampton
    base     = 21
    division =
    { id    = { type = 13016 id = 541 }
      name  = "ĺ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 13016 id = 542 }
      name  = " "
      type  = battleship
      model = 1
    }
    division =
    { id            = { type = 13016 id = 543 }
      name          = " "
      type          = carrier
      model         = 1
      extra         = cag
      brigade_model = 3
    }
    division =
    { id            = { type = 13016 id = 544 }
      name          = "նī˹ "
      type          = escort_carrier
      model         = 0
    }
    division =
    { id    = { type = 13016 id = 545 }
      name  = "Ů "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 546 }
      name  = "˺ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 547 }
      name  = "޺ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 548 }
      name  = "11֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 13016 id = 570 }
      name  = "12֧ "
      type  = destroyer
      model = 1
    }
  }
  # 4th Submarine Squadron#
  navalunit =
  { name     = "Ǳͧ "
    id       = { type = 13106 id = 549 }
    location = 21 # Southampton
    base     = 21
    division =
    { id    = { type = 13016 id = 550 }
      name  = "10Ǳ֧ͧ "
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 13016 id = 551 }
      name  = "11Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
  }
  # 2nd Transport Squadron#
  navalunit =
  { name     = "ڶ佢 "
    id       = { type = 13016 id = 552 }
    location = 21 # Southampton
    base     = 21
    division =
    { id    = { type = 13016 id = 553 }
      name  = "5佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 554 }
      name  = "6佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 5662 }
      name  = "7佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 5663 }
      name  = "8佢֧ "
      type  = transport
      model = 0
    }
  }
  # Humber Force#
  navalunit =
  { name     = " "
    id       = { type = 13016 id = 555 }
    location = 13
    base     = 13
    division =
    { id    = { type = 13016 id = 556 }
      name  = "ϰնغ "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 13016 id = 557 }
      name  = "˹ "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 13016 id = 558 }
      name  = "13֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 559 }
      name  = "14֧ "
      type  = destroyer
      model = 1
    }
  }
  # Non-Associated Destroyers#
  navalunit =
  { name     = "ʮ𽢶 "
    id       = { type = 13016 id = 571 }
    location = 23 # Plymouth
    base     = 23
    division =
    { id    = { type = 13016 id = 572 }
      name  = "15֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 573 }
      name  = "16֧ "
      type  = destroyer
      model = 0
    }
  }
  navalunit =
  { name     = "к "
    id       = { type = 13016 id = 579 }
    location = 906 # Alexandria
    base     = 906
    division =
    { id    = { type = 13016 id = 580 }
      name  = "ս "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 13016 id = 581 }
      name  = "ķ "
      type  = battleship
      model = 1
    }
    division =
    { id    = { type = 13016 id = 582 }
      name  = "Ǻ "
      type  = battleship
      model = 1
    }
    division =
    { id            = { type = 13016 id = 583 }
      name          = "ٺ "
      type          = carrier
      model         = 1
      extra         = cag
      brigade_model = 3
    }
    division =
    { id    = { type = 13016 id = 584 }
      name  = "ĺ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 585 }
      name  = "ʲպ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 586 }
      name  = "˹ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 587 }
      name  = "ˮ "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 13016 id = 588 }
      name  = " "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 13016 id = 589 }
      name  = "Ǻ "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 13016 id = 590 }
      name  = "Ĵ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 591 }
      name  = "17֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 592 }
      name  = "18֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 13016 id = 593 }
      name  = "19֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 594 }
      name  = "20֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 595 }
      name  = "21֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 13016 id = 596 }
      name  = "22֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 597 }
      name  = "23֧ "
      type  = destroyer
      model = 1
    }
  }
  navalunit =
  { id       = { type = 13016 id = 700 }
    name     = "۾ "
    location = 906
    base     = 906
    division =
    { id            = { type = 13016 id = 701 }
      name          = "۾˺ "
      type          = escort_carrier
      model         = 0
      strength      = 100
    }
  }
  # 1st Submarine Squadron#
  navalunit =
  { name     = "һǱͧ "
    id       = { type = 13016 id = 598 }
    location = 906 # Alexandria
    base     = 906
    division =
    { id    = { type = 13016 id = 599 }
      name  = "1Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 13016 id = 903 }
      name  = "2Ǳ֧ͧ "
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 13016 id = 900 }
      name  = "3Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 13016 id = 902 }
      name  = "4Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
  }
  # 3rd Transport Squadron#
  navalunit =
  { name     = "佢 "
    id       = { type = 13016 id = 601 }
    location = 906 # Alexandria
    base     = 906
    division =
    { id    = { type = 13016 id = 602 }
      name  = "9佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 603 }
      name  = "10佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 5664 }
      name  = "11佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 5665 }
      name  = "12佢֧ "
      type  = transport
      model = 0
    }
  }
  # 4th Transport Squadron#
  navalunit =
  { name     = "佢 "
    id       = { type = 13016 id = 9879 }
    location = 5 # Scapa Flow
    base     = 5
    division =
    { id    = { type = 13016 id = 9880 }
      name  = "13佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 9881 }
      name  = "14佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 9882 }
      name  = "15佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 9883 }
      name  = "16佢֧ "
      type  = transport
      model = 0
    }
  }
  # 5th Transport Squadron#
  navalunit =
  { name     = "佢 "
    id       = { type = 13016 id = 9884 }
    location = 23 # Plymouth
    base     = 23
    division =
    { id    = { type = 13016 id = 9885 }
      name  = "17佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 9886 }
      name  = "18佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 9887 }
      name  = "19佢֧ "
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 13016 id = 9888 }
      name  = "20佢֧ "
      type  = transport
      model = 0
    }
  }
  # North Atlantic Command#
  navalunit =
  { name     = "˾ "
    id       = { type = 13016 id = 604 }
    location = 348 # Gibraltar
    base     = 348
    division =
    { id    = { type = 13016 id = 605 }
      name  = "º "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 606 }
      name  = "նغ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 607 }
      name  = "24֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 608 }
      name  = "25֧ "
      type  = destroyer
      model = 1
    }
  }
  # South Atlantic Command#
  navalunit =
  { name     = "ϴ˾ "
    id       = { type = 13016 id = 609 }
    location = 988 # Freetown
    base     = 988
    division =
    { id    = { type = 13016 id = 610 }
      name  = "Ǻ "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 13016 id = 613 }
      name  = "ȶ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 614 }
      name  = "° "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 615 }
      name  = "˹ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 616 }
      name  = "ֿ˹ "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 13016 id = 617 }
      name  = " "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 611 }
      name  = "ǲ "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 612 }
      name  = "η "
      type  = light_cruiser
      model = 0
    }
    division =
    { id    = { type = 13016 id = 578 }
      name  = "26֧ "
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 13016 id = 618 }
      name  = "27֧ "
      type  = destroyer
      model = 0
    }
  }
  # America and West Indies Station#
  navalunit =
  { name     = "޺ӡȺս "
    id       = { type = 13016 id = 619 }
    location = 538 # Bermuda
    base     = 538
    division =
    { id    = { type = 13016 id = 620 }
      name  = "˺ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 621 }
      name  = "Ի "
      type  = light_cruiser
      model = 2
    }
    division =
    { id    = { type = 13016 id = 622 }
      name  = "Լ˺ "
      type  = heavy_cruiser
      model = 1
    }
  }
  navalunit =
  { name     = "йս "
    id       = { type = 13016 id = 623 }
    location = 1315 # Hong Kong
    base     = 1315
    division =
    { id            = { type = 13016 id = 624 }
      name          = "ӥ "
      type          = escort_carrier
      model         = 1
    }
    division =
    { id    = { type = 13016 id = 625 }
      name  = "غ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 626 }
      name  = "ֶ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 627 }
      name  = " "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 13016 id = 628 }
      name  = "غ "
      type  = heavy_cruiser
      model = 1
    }
    division =
    { id    = { type = 13016 id = 629 }
      name  = "28֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 630 }
      name  = "29֧ "
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 13016 id = 631 }
      name  = "30֧ "
      type  = destroyer
      model = 0
    }
  }
  # 3rd Submarine Squadron#
  navalunit =
  { name     = "Ǳͧ "
    id       = { type = 13016 id = 632 }
    location = 1315 # Hong Kong
    base     = 1315
    division =
    { id    = { type = 13016 id = 633 }
      name  = "8Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 13016 id = 634 }
      name  = "9Ǳ֧ͧ "
      type  = submarine
      model = 2
    }
  }
  # East Indies Station#
  navalunit =
  { name     = "ӡս "
    id       = { type = 13016 id = 636 }
    location = 1517 # Colombo
    base     = 1517
    division =
    { id    = { type = 13016 id = 637 }
      name  = "˹غ "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 13016 id = 638 }
      name  = "ֺ "
      type  = light_cruiser
      model = 3
    }
    division =
    { id    = { type = 13016 id = 639 }
      name  = "˹غ "
      type  = light_cruiser
      model = 3
    }
  }
  # ############################
  # ROYAL AIR FORCE 1939 OOB####
  # ############################
  airunit =
  { location = 17
    base     = 17
    id       = { type = 13016 id = 170 }
    name     = "ǰд(1սը) "
    division =
    { experience = 35
      id         = { type = 13016 id = 171 }
      name       = "ǰд "
      type       = tactical_bomber
      model      = 1
      strength   = 85
    }
  }
  airunit =
  { location = 14
    base     = 14
    id       = { type = 13016 id = 172 }
    name     = "2սԺը "
    division =
    { experience = 35
      id         = { type = 13016 id = 173 }
      name       = "2սԺը "
      type       = strategic_bomber
      model      = 0
      strength   = 85
    }
  }
  airunit =
  { location = 11
    base     = 11
    id       = { type = 13016 id = 174 }
    name     = "3սԺը "
    division =
    { experience = 35
      id         = { type = 13016 id = 175 }
      name       = "71սԺը "
      type       = strategic_bomber
      model      = 0
      strength   = 85
    }
  }
  airunit =
  { location = 11
    base     = 11
    id       = { type = 13016 id = 3174 }
    name     = "ʮ˾ "
    division =
    { experience = 35
      id         = { type = 13016 id = 3175 }
      name       = "16ը "
      type       = naval_bomber
      model      = 0
    }
  }
  airunit =
  { location = 11
    base     = 11
    id       = { type = 13016 id = 2174 }
    name     = "ʮ˺˾ "
    division =
    { experience = 35
      id         = { type = 13016 id = 2175 }
      name       = "18ը "
      type       = naval_bomber
      model      = 0
    }
  }
  airunit =
  { location = 11
    base     = 11
    id       = { type = 13016 id = 176 }
    name     = "4սԺը "
    division =
    { experience = 35
      id         = { type = 13016 id = 177 }
      name       = "3սԺը "
      type       = strategic_bomber
      model      = 0
      strength   = 85
    }
  }
  airunit =
  { location = 17
    base     = 17
    id       = { type = 13016 id = 178 }
    name     = "5սը "
    division =
    { experience = 35
      id         = { type = 13016 id = 179 }
      name       = "5սը "
      type       = tactical_bomber
      model      = 1
      strength   = 85
    }
  }
  airunit =
  { location = 20
    base     = 20
    id       = { type = 13016 id = 180 }
    name     = "11ս "
    division =
    { experience = 35
      id         = { type = 13016 id = 181 }
      name       = "11ս "
      type       = interceptor
      model      = 1
      strength   = 85
    }
  }
  airunit =
  { location = 20
    base     = 20
    id       = { type = 13016 id = 182 }
    name     = "12ս "
    division =
    { experience = 35
      id         = { type = 13016 id = 183 }
      name       = "12ս "
      type       = interceptor
      model      = 1
      strength   = 85
    }
  }
  airunit =
  { location = 21
    base     = 21
    id       = { type = 13016 id = 184 }
    name     = "13ս "
    division =
    { experience = 35
      id         = { type = 13016 id = 185 }
      name       = "13ս "
      type       = interceptor
      model      = 1
      strength   = 85
    }
  }
  airunit =
  { location = 1866 # Baghdad
    base     = 1866
    id       = { type = 13016 id = 186 }
    name     = "жվ˾ "
    division =
    { experience = 35
      id         = { type = 13016 id = 187 }
      name       = "ж "
      type       = tactical_bomber
      model      = 2
      strength   = 85
    }
  }
  airunit =
  { location = 1457
    base     = 1457
    id       = { type = 13016 id = 188 }
    name     = "ӡȿվ˾ "
    division =
    { experience = 35
      id         = { type = 13016 id = 189 }
      name       = "ӡȴ "
      type       = tactical_bomber
      model      = 2
      strength   = 85
    }
  }
  airunit =
  { location = 1353 # Singapore
    base     = 1353
    id       = { type = 13016 id = 190 }
    name     = "Զվ˾ "
    division =
    { experience = 35
      id         = { type = 13016 id = 191 }
      name       = "Զ "
      type       = tactical_bomber
      model      = 2
      strength   = 85
    }
  }
  # Under Construction#
  division_development =
  { name  = " "
    type  = battleship
    model = 3
    cost  = 8.5
    id    = { type = 13016 id = 800 }
    date  = { year = 1940 month = december day = 11 }
  }
  division_development =
  { name  = "ʿӺ "
    type  = battleship
    model = 3
    cost  = 8.5
    id    = { type = 13016 id = 801 }
    date  = { year = 1941 month = march day = 31 }
  }
  division_development =
  { name  = "׿Խ "
    type  = carrier
    model = 3
    cost  = 5.9
    id    = { type = 13016 id = 802 }
    date  = { year = 1940 month = may day = 25 }
    extra = cag
    brigade_model = 3
  }
  division_development =
  { name  = "ʤ "
    type  = carrier
    model = 3
    cost  = 5.9
    id    = { type = 13016 id = 803 }
    date  = { year = 1941 month = may day = 15 }
    extra = cag
    brigade_model = 3
  }
  division_development =
  { name  = "η "
    type  = carrier
    model = 3
    cost  = 5.9
    id    = { type = 13016 id = 804 }
    date  = { year = 1940 month = november day = 24 }
    extra = cag
    brigade_model = 3
  }
  division_development =
  { name  = "31֧ "
    type  = destroyer
    model = 1
    cost  = 1.7
    id    = { type = 13016 id = 805 }
    date  = { year = 1939 month = october day = 1 }
  }
  division_development =
  { name  = "13Ǳ֧ͧ "
    type  = submarine
    model = 2
    cost  = 1.7
    id    = { type = 13016 id = 807 }
    date  = { year = 1939 month = october day = 1 }
  }
  division_development =
  { name  = "14Ǳ֧ͧ "
    type  = submarine
    model = 2
    cost  = 1.7
    id    = { type = 13016 id = 808 }
    date  = { year = 1939 month = november day = 1 }
  }
}
